// Content script for fixyourfeed.xyz
// Relays resolve requests to the background script which uses X tab to resolve

console.log('FixYourFeed relay script loaded on fixyourfeed.xyz');

// Listen for messages from the page
window.addEventListener('message', async (event) => {
  if (event.data && event.data.type === 'FIXFEED_RESOLVE_REQUEST') {
    console.log('Received resolve request for:', event.data.userId);
    
    try {
      // Send to background script
      const response = await chrome.runtime.sendMessage({
        action: 'resolveUserId',
        userId: event.data.userId
      });
      
      // Send response back to page
      window.postMessage({
        type: 'FIXFEED_RESOLVE_RESPONSE',
        userId: event.data.userId,
        success: response?.success || false,
        handle: response?.handle,
        error: response?.error
      }, '*');
    } catch (e) {
      console.error('Error relaying resolve request:', e);
      window.postMessage({
        type: 'FIXFEED_RESOLVE_RESPONSE',
        userId: event.data.userId,
        success: false,
        error: e.message
      }, '*');
    }
  }
});

// Let the page know the extension is available
window.postMessage({ type: 'FIXFEED_EXTENSION_READY' }, '*');
